import readline from "readline-sync"; // pour utiliser le module readline-sync
import { encore } from "./utils.js"; // pour utiliser le module utils

/**
 * retourne une chaîne de caractères correspondant à la concaténation 
 * des chaînes motif1 et motif2 de manière alternée, nbMotifs étant 
 * le nombre de motifs total (nombre de motif1 + nombre de motif2) présents 
 * dans la chaîne retournée.
 * 
 * @param {number} nbMotifs nombre total de motifs présents dans la chaîne retournée 
 * @param {string} motif1 le premier motif de la chaîne retournée
 * @param {string} motif2 le deuxième motif de la chaîne retournée
 * @returns {string} chaîne constituée de nbMotifs otifs en alternant motif1 et motif2
 */
function motifsAlternes(nbMotifs, motif1, motif2) {
	let res = "";
	for (let i = 0; i < nbMotifs; i++) {
		res += i % 2 === 0 ? motif1 : motif2;
	}
	return res;
}

function afficherLignesMotifsAlternes(nbLignes, nbMotifs, motif1, motif2) {
	for (let i = 0; i < nbLignes; i++) {

	}
}

function creerMotif(carMotif1,nbCarParMotif) {
	let res = '';
	for (let i = 0; i < nbCarParMotif; i++) {
		res += carMotif1;
	}
	return res;
}

console.log("Tests de la fonction motifsAlternes\n ");
console.log(motifsAlternes(5, "+++", "%%"));
console.log(motifsAlternes(6, "000", "---"));
console.log(motifsAlternes(7, "000", "---"));


function damier(hauteur,hauteurLigne, nbMotifs, motif1, motif2) {
	const lignePaire = motifsAlternes(nbMotifs, motif1, motif2);
	const ligneImpaire = motifsAlternes(nbMotifs, motif2, motif1);

	for (let i = 0; i < hauteur; i++) {
		if (i % 2 === 0) {
			for (let j = 0; j < hauteurLigne; j++) console.log(lignePaire);
		} else {
			for (let j = 0; j < hauteurLigne; j++) console.log(ligneImpaire);
		}
	}
}
// damier(10, 10, "XXX", "   ");
console.log('\nTests de la fonction damier\n');
damier(3, 2, 5, "---", "000");
console.log();
damier(4, 3, 7, "XXXX", "    ");

console.log('\nGénerez vos propres damiers');
do {
	console.log();
	let carMotif1 = readline.question("caractère du motif1 : ");
	let carMotif2 = readline.question("caractère du motif2 : ");
	let nbCarParMotif = readline.questionInt("nombre de caractères par motif : ");
	let nbMotifs = readline.questionInt("nombre de motif alternés sur une ligne : ");
	let hauteurLigne = readline.questionInt("nombre de lignes de motifs alternés pour une ligne du damier : ");
	let hauteur = readline.questionInt("nombre de lignes de lignes du damier : ");
	console.log();
	damier(hauteur,hauteurLigne, nbMotifs, creerMotif(carMotif1,nbCarParMotif), creerMotif(carMotif2,nbCarParMotif));
	console.log();
} while (encore('Voulez-vous afficher un autre damier ?'));