import fs from "fs";

/**
 * Classe représentant une liste de tâches.
 * 
 * Les tâches sont objets litéraux de la forme
 * 
 *   {
 *      id: 1764440896115,                          // identifiant d'une tâche voir note 1 ci-dessous
 *      description: "Préparer un sujet d'examen",  // description textuelle de la tâche
 *      terminee: false,                            // indique si la tâche est terminée
 *      priorite: "Haute",                          // priorité de la tâche, "Haute", "Moyenne" ou "Basse"
 *  dateCreation: "29/11/2025 19:28:16"             // date et heure de création de la tâche
 * }
 * 
 * Les tâches sont stockées dans un tableau (attributs taches). La classe définit
 * un certain nombre de méthodes pour la gestion de cette liste :  chargement/sauvegarde
 * dans un fichier, affcichage de la liste des tâches, ajout/suppression de taches,
 * changement de statu d'une tache, tri de la liste des taches selon des critères
 * (date de création, niveau de priorité, statut terminé ou non terminé)
 */
export class ListeDeTaches {

    // ===== NE PAS MODIFIER LE CONSTRUCTEUR ET LA METHODE SauvegarderTaches =====

    /**
     * Crée un liste de tâches soit vide si aucun paramètre n'est fourni au constructeur,
     * soit intialisée avec les tâches contenues dans le fichier JSON dont le nom est passé
     * en paramètre. 
     * Les tâches sont stockées dans l'attribut taches un tableau d'objets taches ..
     * 
     * @param {string} nomFichierTaches nom du fichier JSON depuis lequel les tâches sont lues.
     */
    constructor(nomFichierTaches) {
        if (!nomFichierTaches) {
            // on crée une liste de taches vide.
            this.taches = [];
        }
        else {
            // creation de la liste de tâches à partir du nom de fichier JSON donné
            const data = fs.readFileSync(nomFichierTaches, "utf8");
            this.taches = JSON.parse(data);
            console.log(`✅ ${this.taches.length} tâche(s) chargée(s) depuis le fichier.`);
        }

    }

    /**
     * Sauvegarde les tâches dans un fichier JSON
     *
     * @param {string} nomFicherTaches nom du fichier JSON dans lequel les tâches de la lsite sont sauvegardées
     */
    sauvegarderTaches(nomFicherTaches) {
        fs.writeFileSync(nomFicherTaches, JSON.stringify(this.taches, null, 2), { encoding: "utf8" });
        console.log("\nTâches sauvegardées avec succès!");
    }

    // ==== PARTIE 1.1 COMPLETER LA CLASSE LISTE DE TACHES ===
    // ===== À VOUS DE COMPLÉTER LES MÉTHODES CI-DESSOUS =====

    // --- question 1 -----------------------
    /**
     * Affiche sur la console toutes les tâches de la liste
     */
    afficherLesTaches() {
        // TODO: À compléter
    }

    // ------question 2 ----------------------------------
    /**
     * le nombre de tâches contenues dans la liste
     */
    get nbTaches() {
        // TODO: À compléter
    }

    /**
     * le nombre de tâches marquées comme terminées
     */
    get nbTachesTerminees() {
        // TODO: À compléter
    }

    /**
     * Renvoie le nombre de tâches de la liste ayant une priorité donnée
     * @param {string} niveauPriorite  le niveau de priorité à rechercher ('Haute', 'Moyenne', 'Basse')
     * @returns {number} le nombre de tâches ayant le niveau de priorité niveauPriorite
     */
    nbTachesDePriorite(niveauPriorite) {
        // TODO: À compléter
    }

    // ------question 3 ----------------------------------
    /**
     * Marque une tâche de la liste comme étant terminée
     * @param {*} index le rang dans la liste à marquer comme étant terminée
     */
    terminer(index) {
        // TODO: À compléter
        // on ne fera pas de vérification sur la validité de l'index
        // attention l'index pour l'utilsiateur commence à 1 (1ère tâche) alors
        // que dans un tableau les indexs commencent à 0
    }

    // ------question 4 ----------------------------------
    /**
     * ajoute une nouvelle tâche en fin de la liste
     * @param {string} description  la description textuelle de la tâche
     * @param {string} priorite priorité de la tache (par défault "Basse")
     */
    nouvelleTache(description, priorite = "Basse") {
        // TODO: À compléter
    }

    // ------question 5 ----------------------------------
    /**
     * Supprime une tâche de la liste
     * @param {*} index le rang dans la liste de la tâche retirer
     */
    supprimer(index) {
        // TODO: À compléter
        // on ne fera pas de vérification sur la validité de l'index
        // attention l'index pour l'utilsiateur commence à 1 (1ère tâche) alors
        // que dans un tableau les indexs commencent à 0
    }

    // ------question 6 ----------------------------------
    /**
     * Supprime de la liste toutes les tâches marquées terminées
     */
    supprimerTachesTerminees() {
        // TODO: À compléter
    }

    // ===== PARTIE 1.2 TRI UTILISE par app.js =====
    // ===== NE PAS MODIFIER LA METHODE trier =====

    /**
     * Trie la liste des tâches selon le critère de comparaison fournit par la fonction 
     * passée en paramètre.
     * @param {Function} fonctionDeComparaison la fonction de comparaison. Cette fonction
     * prend en paramètre deux tâches a et b et renvoie 
     * - un nombre négatif si a est plus petit que b selon le critère de tri
     * - 0 si a est idendique à b selon le critère de tri
     * - un nombre positif si a est plus grand que b selon le critère de tri
     */
    trier(fonctionDeComparaison) {
        this.taches.sort(fonctionDeComparaison);
    }

}




