/*
 * © Philippe GENOUD - Université Grenobles Alpes
 * Equipe STeamer - Laboratoire d'Informatique de Grenoble
 */
import {Visage} from './Visage.js'
import {VisageExpressif} from './VisageExpressif.js'

//--------------------------------------------------------------------------------
// Programme principal exécuté au chargement de la page testVisagesExpressifs.
// Deux visages sont créés (v1 un VisageExpressif, v2 un Visage 'normal') et
// sont animés dans le canvas "zoneDessin"
// -------------------------------------------------------------------------------

const canvas = document.getElementById("zoneDessin"); // récupération de l'objet correspondant à l'élément canvas

let timerId = null;
const boutonStart = document.getElementById("btnStart");
const boutonStop = document.getElementById("btnStop");

let v1 = new VisageExpressif(canvas, canvas.width / 2, canvas.height / 2, 40, 5, 3);
let v2 = new Visage(canvas, canvas.width / 2 + 2 * v1.rayon, canvas.height / 2, 40, 3, -4);
v1.dessiner();
v2.dessiner();

boutonStart.addEventListener("click", function () {
	timerId = setInterval(() => {
		v1.deplacer();
		v2.deplacer();
		// on efface le canvas
		canvas.getContext("2d").clearRect(0, 0, canvas.width, canvas.height);
		// on redessine
		v1.dessiner();
		v2.dessiner();
	}, 20);
	boutonStart.disabled = true;
	boutonStop.disabled = false;
});

boutonStop.addEventListener("click", function () {
	clearInterval(timerId);
	timerId = null;
	boutonStart.disabled = false;
	boutonStop.disabled = true;
});
