/* 
 * Dessine un escalier dans le canvas
 * l'esclier est paramtré par:
 * - la hauteur d'une marche (définie dans input d'id 'hauteurMarche'
 * - le nombre de marche (défine dans l'input d'id 'nbreMarches');
 */

/**
 * effacer le contenu du canvas
 * @returns {undefined}
 */
function effacer() {
    let canvas = document.getElementById('zoneDessin');
    let graphicContext = canvas.getContext('2d');
    graphicContext.clearRect(0, 0, canvas.width, canvas.height);
}

/**
 * dessine l'escalier dans le canvas
 * @returns {undefined}
 */
function dessiner() {
    let canvas = document.getElementById('zoneDessin');
    let graphicContext = canvas.getContext('2d');
    graphicContext.strokeStyle = 'red';
    graphicContext.lineWidth = 3;
    graphicContext.fillStyle = 'yellow';

    let hauteurMarche = parseFloat(document.getElementById('hauteurMarche').value);
    let nbreMarches = parseFloat(document.getElementById('nbreMarches').value);
    let yMarche = 0;
    let largeurMarche = hauteurMarche;
    for (let i = 1; i <= nbreMarches; i++) {
        // ième marche
        graphicContext.fillRect(0, yMarche, largeurMarche, hauteurMarche);
        graphicContext.strokeRect(0, yMarche, largeurMarche, hauteurMarche);
        yMarche += hauteurMarche;
        largeurMarche += hauteurMarche;
    }

}

// associe les gestionnaires d'événements aux boutons effacer et dessiner
document.getElementById("effacer").addEventListener("click", () => effacer());
document.getElementById("dessiner").addEventListener("click", () => dessiner());

