# Jeu de Bataille - Version JavaScript

## Règles du jeu

Le jeu de bataille se joue à deux joueurs :

1. Les 32 cartes sont distribuées équitablement entre les deux joueurs
2. À chaque tour, chaque joueur joue sa carte du dessus
3. Le joueur avec la carte de plus grande valeur remporte les deux cartes
4. En cas d'égalité, c'est "bataille" : les joueurs rejouent
5. Le jeu continue jusqu'à ce qu'un joueur ait toutes les cartes

### Hiérarchie des cartes (ordre croissant)

Sept < Huit < Neuf < Dix < Valet < Dame < Roi < As

## Structure du projet

```
BataillePhil/
├── index.html             # Interface web du jeu
├── style.css              # Styles CSS
├── js/                    # Code JavaScript
│   ├── ValeurCarte.js     # Énumération des valeurs de cartes
│   ├── CouleurCarte.js    # Énumération des couleurs de cartes
│   ├── Carte.js           # Classe représentant une carte
│   ├── PileCartes.js      # Classe pour gérer une pile de cartes
│   ├── Jeu32Cartes.js     # Classe pour représenter un jeu de 32 cartes
│   ├── Joueur.js          # Classe représentant un joueur
│   ├── Bataille.js        # Logique principale du jeu
│   ├── BatailleGUI.js     # Contrôleur de l'interface graphique
│   └── BatailleCLI.js     # Version console (Node.js)
└── src/bataille/images/   # Images des cartes (réutilisées du projet Java)
```

## Comment jouer

### Version Web (Interface Graphique)

1. Ouvrez le fichier `index.html` dans votre navigateur web
2. Cliquez sur "Jouer" pour jouer un tour
3. Cliquez sur "Remporter" quand un joueur gagne le tour
4. Cliquez sur "Nouvelle Partie" pour recommencer

### Version Console (CLI)

Avec Node.js installé :

```bash
node js/BatailleCLI.js
```






