/**
 * BatailleCLI.js
 * Version en ligne de commande du jeu de bataille
 * Pour exécuter : node js/BatailleCLI.js
 */
import readline from 'readline-sync';
import { Bataille } from './Bataille.js';

console.log("=================================");
console.log("    JEU DE BATAILLE - CLI");
console.log("=================================\n");

const bataille = new Bataille("Anna Tomie", "Guy de Michelin");

const joueur1 = bataille.getJoueur(1);
const joueur2 = bataille.getJoueur(2);

let nbCartes = readline.questionInt("nombre de cartes par joueur : ");
bataille.distribuerCartes(nbCartes);
console.log("Les cartes ont été distribuées !\n");

let partieInterrompue = false;

while (!partieInterrompue && !bataille.partieFinie()) {
    console.log("-------------------------");
    console.log(`${joueur1.nom} a ${joueur1.nbCartes} cartes dans son tas`);
    console.log(`${joueur2.nom} a ${joueur2.nbCartes} cartes dans son tas\n`);

    // faire jouer une carte à chacun des joueurs
    bataille.jouerUnTour();
    // afficher les cartes jouées
    console.log(`${joueur1.nom} joue : ${joueur1.carteJouee.nomCourt}`);
    console.log(`${joueur2.nom} joue : ${joueur2.carteJouee.nomCourt}`);

    // on récupère l'éventuel joueur gagnant
    let joueurGagnant = bataille.gagnantDuTour();
    // on affiche les résultats du tour
    if (joueurGagnant !== null) {
        console.log(`\n${joueurGagnant.nom} gagne le tour ! Il(Elle) ramasse les cartes jouées`);
        bataille.donnerLesCartesDuPliA(joueurGagnant);
    } else if (!bataille.partieFinie()) {
        console.log("\nPas de gagnant - BATAILLE, il faut rejouer !");
    }

    // si la partie n'est pas terminée on laisse le choix à l'utilisateur
    // de poursuivree le jeu ou d'interrompre la partie
    if (!bataille.partieFinie()) {
        partieInterrompue = readline.question("\nContinuer [O]ui/[N]on ? ").toUpperCase() === "N";
    }

}

console.log("------------------------");
console.log("\nPartie terminée");

const gagnantPartie = bataille.gagnantPartie();
if (gagnantPartie) {
    console.log(`${gagnantPartie.nom} a gagné !`);
} else {
    console.log("Match nul !");
}

console.log(`\nScore final:`);
console.log(`${joueur1.nom}: ${joueur1.nbCartes} cartes`);
console.log(`${joueur2.nom}: ${joueur2.nbCartes} cartes`);



