import { CouleurCarte } from "./CouleurCarte.js";
import { ValeurCarte } from "./ValeurCarte.js";

/**
 * Classe Carte.
 *
 * Représente une carte à jouer avec une valeur et une couleur.
 */
export class Carte {
    /**
     * Constructeur avec valeur et couleur spécifiées
     * @param {ValeurCarte} valeur - Une valeur de ValeurCarte
     * @param {CouleurCarte} couleur - Une couleur de CouleurCarte
     */
    constructor(valeur, couleur) {
        this.valeur = valeur;
        this.couleur = couleur;
    }

    /**
     * @returns une nouvelle carte tirée au hasard
     */
    static carteAuHasard() {
        // TODO
        //  à vous de compléter
    }

    /**
     * Renvoie le nom de la carte sous la forme textuelle, par exemple
     * "Dame de Pique"
     * @returns {string} Le nom de la carte
     */
    get nom() {
        return this.valeur.nom + " de " + this.couleur.nom;
    }

    /**
     * Renvoie le nom de la carte sous une forme courte , par exemple
     * "D ♠️"
     */
    get nomCourt() {
        return this.valeur.nomCourt + " " + this.couleur.emoji;
    }

    /**
     * Renvoie le nom du fichier image correspondant à la carte
     * @returns {string} Le nom du fichier image
     */
    get nomFichierImage() {
        return this.valeur.nom + "-de-" + this.#sansAccent(this.couleur.nom) + ".png";
    }

    /**
     * Supprime les accents d'une chaîne de caractères
     * le dièse ('#') devant le nom de la méthode signifie qu'il s'agit d'une
     * méthode privée (son nom commence par #) destinée à un usage interne à la classe Carte
     *
     * @param {string} s - La chaîne à traiter
     * @returns {string} La chaîne sans accents
     */
    #sansAccent(s) {
        return s.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }

    /**
     * Renvoie une représentation textuelle de la carte.
     *
     * @param {boolean} formeLongue si true renvoie le nom de la carte (ex 'Dame de Pique'),
     *        sinon renvoie le nom court de la ca&rte (ex 'D ♠️')
     * @returns {string} la chaine de caractères correspondant au nom de la carte dans
     *        la forme demandée
     */
    toString(formeLongue) {
        return formeLongue ? this.nom : this.nomCourt;
    }
}
