/**
 * Énumération représentant la couleur des cartes.
 */

export class CouleurCarte {
    constructor(nom, symbole, emoji) {
        this.nom = nom;
        this.symbole = symbole;
        this.emoji = emoji;
        Object.freeze(this); // Rend l'instance immuable, on ne peut changer ses attributs
    }
    
    toString() {
        return this.nom.toUpperCase();
    }
    
    static PIQUE = new CouleurCarte("pique", "♠", "♠️");
    static COEUR = new CouleurCarte("coeur", "♥", "♥️");
    static CARREAU = new CouleurCarte("carreau", "♦", "♦️");
    static TREFLE = new CouleurCarte("trèfle", "♣", "♣️");
    
    static values() {
        return [this.PIQUE, this.COEUR, this.CARREAU, this.TREFLE];
    }
    
    static fromNom(nom) {
        nom = nom.toLowerCase();
        return this.values().find(c => c.nom === nom);
    }
}

Object.freeze(CouleurCarte); // Empêche d'ajouter de nouvelles couleurs