import { Carte } from "./Carte.js";

/**
 * Classe PileCartes
 * Gère une pile de cartes avec ajout, retrait et mélange
 */
export class PileCartes {
    /**
     * Constructeur, créé une pile vide
     */
    constructor(tailleMax) {
        this.lesCartes = [];  // tableau pour stocker les cartes de la pile
    }

    /**
     * @returns {number} Le nombre de cartes dans la pile
     */
    get nbCartes() {
        return this.lesCartes.length;
    }

    /**
     * Ajoute une carte sur la pile (au sommet)
     * @param {Carte} carte - La carte à ajouter
     */
    ajouterCarteSurLaPile(carte) {
        this.lesCartes.push(carte);
    }

    /**
     * Retire la carte du sommet de la pile
     * @returns {Carte} La carte retirée
     */
    retirerCarte() {
        return this.lesCartes.pop();
    }

    /**
     * @returns {boolean} true si la pile est vide
     */
    estVide() {
        return this.lesCartes.length === 0;
    }

    /**
     * Mélange les cartes dans la pile (avec l'algorithme de Fisher-Yates)
     */
    melanger() {
        for (let i = this.lesCartes.length - 1; i > 0; i--) {
            // Choisir un index aléatoire entre 0 et i (inclus)
            const j = Math.floor(Math.random() * (i + 1));

            // Échanger les cartes aux positions i et j
            const temp = this.lesCartes[i];
            this.lesCartes[i] = this.lesCartes[j];
            this.lesCartes[j] = temp;
        }
    }

    
    /**
     * Affiche sur la console le contenu de la pile (pour debug)
     * les  cartes sont affichées du haut de la pile vers le bas.
     *
     * @param {boolean} formeLongue formeLongue si true affiche le nom des cartes
     *   (ex 'Dame de Pique'), sinon affiche le nom court des cartes (ex 'D ♠️')
     */
    afficher(formeLongue) {
        // TODO
        //  à vous de compléter
    }

    /**
     * @returns {Carte} la carte située au sommet de la pile (null si la pile est vide)
     */
    get sommet() {
        // TODO
        //  à vous de compléter
    }

    /**
     * Vide la pile et renvoie un taableau des cartes qu'elle contient.
     * @returns {Array[Carte]} un tableau contenant toutes les cartes qui étaient dans la pile
     */
    vider() {
        // TODO
        //  à vous de compléter
    }

    /**
     * Recupère les cartes d'une autre pile et les insère sous la pile.
     * Après cette opération autrePileDeCartes doit être vide.
     * @param {PileCartes}  autrePileDeCartes
     */
    recuperer(autrePileDeCartes) {
                // TODO
        //  à vous de compléter
    }

}
