/**
 * fonction de conversion associée au convertisseur qui à partir d'un caractère donné retrouve et affiche 
 * son point de code en décimal et en hexadécimal
 */
function convertChar() {
    // récupère le caractère saisi
    let char = document.getElementById("charInput").value[0]; 
    // retrouve le point code décimal  
    let pointCode = char.codePointAt(0); 
    // affiche le point de code en décimal
    document.getElementById("decimalChar").innerHTML = pointCode;
    // affiche le point de code en hexadécimal
    document.getElementById("hexaChar").innerHTML = "U+" + parseInt(pointCode).toString(16).toUpperCase().padStart(4, '0');

}

/**
 * fonction de conversion associée au convertisseur qui partir d'un point de code décimal donné retrouve et affiche
 * le caractère correspondant ainsi que son point de code en hexadécimal
 */
function convertDecimalCode() {
  // recupère la valeur décimale saisie
  let pointCode = document.getElementById("decimalCodeInput").value;
  // affiche le caractère correspondant au point de code
  document.getElementById("charInt").innerHTML = String.fromCodePoint(pointCode);
  // affiche le point de code en hexadécimal
  document.getElementById("hexaInt").innerHTML = "U+" + parseInt(pointCode).toString(16).toUpperCase().padStart(4, '0');
}


/**
 * fonction de conversion associée au convertisseur qui partir d'un point de code hexadécimal donné retrouve et affiche
 * le caractère correspondant ainsi que son point de code en décimal
 */
function convertHexadecimalCode() {
    // recupère la valeur hexadécimale saisie
    let pointCodeHexa = document.getElementById("hexadecimalCodeInput").value;
    // convertit le point de code en décimal
    let pointCode = parseInt(pointCodeHexa, 16);
    // affiche le caractère correspondant au point de code
    document.getElementById("charHexa").innerHTML = String.fromCodePoint(pointCode);
    // affiche le point de code en décimal
    document.getElementById("decimalHexa").innerHTML = pointCode;

}


// associe les fonctions de conversion aux différents boutons des convertisseurs
document.getElementById("convertChar").addEventListener("click", convertChar);
document.getElementById("convertInt").addEventListener("click", convertDecimalCode);
document.getElementById("convertHexa").addEventListener("click", convertHexadecimalCode);

// permet de faire la conversion en tapant entrée dans le champ de saisie d'un convertisseur
document.getElementById('charInput').addEventListener('keydown', function(event) {
  if (event.key === 'Enter') {
    document.getElementById('convertChar').click();
  }
});
document.getElementById('decimalCodeInput').addEventListener('keydown', function(event) {
  if (event.key === 'Enter') {
    document.getElementById('convertInt').click();
  }
});
document.getElementById('hexadecimalCodeInput').addEventListener('keydown', function(event) {
  if (event.key === 'Enter') {
    document.getElementById('convertHexa').click();
  }
});
